//Copyright 2012-2013 Adobe Systems Incorporated.  All rights reserved.

var helpDoc = MM.HELP_jQuerySlider;

var SLIDER_ID;
var	MIN_INPUT;
var	MAX_INPUT;
var	STEP_INPUT;
var RANGE_CHECK;
var RANGE_LIST;
var	VALUE_INPUT;
var ANIMATE_CHECK;
var ANIMATE_LIST;
var ORIENTATION_LIST;


// ********************* API FUNCTIONS ***************************

//--------------------------------------------------------------------
// FUNCTION:
//   canInspectSelection
//
// DESCRIPTION:
//   This is a Property Inspector API function that gets called
//   whenever the selection in the document changes to decide whether
//   or not this property inspector should be displayed.
//
// ARGUMENTS:
//  None
//
// RETURNS:
//   true if the currently selected node is a Slider element,
//   false if it is not.
//--------------------------------------------------------------------

function canInspectSelection() 
{
  var bCanInspectSelection = false;
  var dom = dw.getDocumentDOM();
  var selectedNode = dom.getSelectedNode();
	
  if ( !selectedNode || !selectedNode.getTranslatedAttribute )
    return false;

  var attr = selectedNode.getTranslatedAttribute('slider');
  if ( attr && attr.length > 0 )
  {
    bCanInspectSelection = true;
    
    // If the widget manager is out of sync, run the translator
    var widgetMgr = JQuery.DesignTime.Widget.Manager.getManagerForDocument(dom); 
	
    if ( !widgetMgr.getWidget('slider', selectedNode.id ) )
    { 
      dom.runTranslator("jQuery Widget");

      if ( !widgetMgr.getWidget('slider', selectedNode.id ) )
      { 
        // Running the translator failed to create a design time object
        // for this widget. Either caInspectSelection() was called in the
        // middle of an edit operation, which prevents the translator from
        // running right now, or an error occurred during the translation.

        bCanInspectSelection = false;
      }
    }  
  }

  return bCanInspectSelection;
}

//--------------------------------------------------------------------
// FUNCTION:
//   initializeUI
//
// DESCRIPTION:
//   This is an internal utility function that searches through the
//   Property Inspector document to find all of the UI controls we
//   will programatically manipulate, and stores handles to them in
//   global variables which are used in some of the other functions
//   for this Property Inspector.
//
// ARGUMENTS:
//  None
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------

function initializeUI() 
{
	SLIDER_ID = document.getElementById("idInput");
	MIN_INPUT = document.getElementById("minInput");
	MAX_INPUT = document.getElementById("maxInput");
	STEP_INPUT = document.getElementById("stepInput");
	RANGE_CHECK = document.getElementById("rangeCheck");
  RANGE_LIST = new ListControl("rangeSelect");
	VALUE_INPUT = document.getElementById("valueInput")
	ANIMATE_CHECK = document.getElementById("animateCheck");
  ANIMATE_LIST = new ListControl("animateSelect");
  ORIENTATION_LIST = new ListControl("orientationSelect");
	
}

//--------------------------------------------------------------------
// FUNCTION:
//   inspectSelection
//
// DESCRIPTION:
//   This is a Property Inspector API function that gets called
//   whenever the selection in the document has changed and it has
//   been decided that this Property Inspector should be displayed.
//   This function syncs up the Property Inspector UI with the
//   widget's design-time object so that it accurately reflects
//   what is in the widget HTML markup and its JS constructor.
//
// ARGUMENTS:
//  None
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------

function inspectSelection() 
{
	dw.logEvent(UT_JQUERY_SLIDER, UT_JQUERY_SLIDER_INSPECT);
	// Call initializeUI() here; it's how the global variables get
  // initialized. The onLoad event on the body tag is never triggered
  // in inspectors.
  initializeUI();
	
  var dom = dw.getDocumentDOM();
  var selectedNode = dom.getSelectedNode();
  if (!canInspectSelection())
    return;
		
	var divId = selectedNode.id;
  // Update the ID field in the PI.
  SLIDER_ID.value = divId;	
	
	var widgetMgr = JQuery.DesignTime.Widget.Manager.getManagerForDocument(dom); 
  
  if (!widgetMgr)
	return;
	
	var slider = widgetMgr.getWidget('slider', divId);
	
	if (!slider)
	{
		return;
	}
	
	if (slider && slider.recalculateOpts)
		slider.recalculateOpts();
	
	MIN_INPUT.value = slider.getMinValue();
	
	if( MIN_INPUT.value == "" )
		MIN_INPUT.value = "0";
		
	MAX_INPUT.value = slider.getMaxValue();
	
	if( MAX_INPUT.value == "" )
		MAX_INPUT.value = "100";
		
	STEP_INPUT.value = slider.getStepValue();
	
	if( STEP_INPUT.value == "" )
		STEP_INPUT.value = "1";
	
	RANGE_CHECK.checked = slider.getRangeCheckValue();
	
	var rangeListArray = slider.getRangeArray();
	RANGE_LIST.setAll(rangeListArray, rangeListArray);
	if( rangeListArray.length )
		RANGE_LIST.setIndex(slider.getRangeListIndex());
	
	VALUE_INPUT.value = slider.getValue().toString();
	
	ANIMATE_CHECK.checked = slider.getAnimateCheckValue();
	var animateValue = slider.getAnimateListIndexOrValue();
	var animateListArray = slider.getAnimateArray();
	ANIMATE_LIST.setAll(animateListArray, animateListArray);
	if( animateListArray.length )
	{
		if( typeof animateValue == 'number' )
			ANIMATE_LIST.setIndex(animateValue);
		else
			ANIMATE_LIST.setValue(animateValue);
	}
	
	var OrientationListArray = slider.getOrientationArray();
	ORIENTATION_LIST.setAll(OrientationListArray, OrientationListArray);
	if( OrientationListArray.length )
		ORIENTATION_LIST.setIndex(slider.getOrientationListIndex());	
	
	enableControls(slider);
}

//--------------------------------------------------------------------
// FUNCTION:
//   enableControls
//
// DESCRIPTION:
//   This internal utility function enables/disables the controls
//   in the Property Inspector based on the state of the widget
//   design-time object.
//
// ARGUMENTS:
//  acc - object - The widget design-time object.
//  errorOnPage - boolean - true if the widget markup is invalid,
//                          false if the markup is valid.
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------

function enableControls(slider)
{
	if( RANGE_LIST.getLen() > 0 && RANGE_CHECK.checked )
	{
		RANGE_LIST.enable();
	}
	else
	{
		RANGE_LIST.setIndex(0);
		RANGE_LIST.disable();
	}
		
	if( ANIMATE_LIST.getLen() > 0 && ANIMATE_CHECK.checked )	
	{
		ANIMATE_LIST.enable();
	}
	else
	{
		ANIMATE_LIST.setIndex(0);
		ANIMATE_LIST.disable();
	}
		
	if( ORIENTATION_LIST.getLen() > 0 )	
		ORIENTATION_LIST.enable();
	else
		ORIENTATION_LIST.disable();	
	
}

//--------------------------------------------------------------------
// FUNCTION:
//   updateTag
//
// DESCRIPTION:
//   This function handles all of the user actions triggered by the
//   user from the Propery Inspector controls.
//
// ARGUMENTS:
//  action - string - The name of the action to perform.
//
// RETURNS:
//   N/A
//--------------------------------------------------------------------
function updateTag(action)
{
	var dom = dw.getDocumentDOM();
	var selectedNode = dom.getSelectedNode();
	if (!canInspectSelection())
		return;
  
	var divId = selectedNode.id;
  
	if (!divId)
		return;
  
	var widgetMgr = JQuery.DesignTime.Widget.Manager.getManagerForDocument(dom); 
	var slider = widgetMgr.getWidget('slider', divId );
	
	if (!slider)
		return;
		
	if (action)
	{
		switch (action)
		{
			case "id":
			{
			// Validate the new id.
        var newId = SLIDER_ID.value;
        if ( newId == divId )
          return; // Nothing to change.
        
        if ( newId.length == 0 )
        {
          alert(dw.loadString("jquery/widget/alert/need unique id"));
          return;
        }
        
        if ( dom.getElementById(newId) )
        {
          alert(dw.loadString("jquery/widget/alert/id already exists"));
          return;
        }
        
        if ( !dwscripts.isValidID(newId) )
        {
          alert(dw.loadString("jquery/widget/alert/id is invalid"));
          return;
        }
        
        // Update the constructor.
        slider.updateWidgetId(newId);

        // Update the WidgetManager for the new ID.
        widgetMgr.setWidget('slider', newId, slider );
			}
			break;
			case "setMin":
			{
				slider.setMinValue(MIN_INPUT.value);
			}
			break;
			case "setStep":
			{
				slider.setStepValue(STEP_INPUT.value);
			}
			break;
			case "setMax":
			{
				slider.setMaxValue(MAX_INPUT.value);
			}
			break;
			case "setRangeCheck":
			{
				slider.setRangeCheckValue(RANGE_CHECK.checked);
			}
			break;
			case "setRange":
			{
				slider.setRangeListIndex(RANGE_LIST.getIndex());
			}
			break;
			case "setValue":
			{
				slider.setValue(VALUE_INPUT.value);
			}
			break;
			case "setAnimateCheck":
			{
				slider.setAnimateCheckValue(ANIMATE_CHECK.checked);
			}
			break;
			case "setAnimate":
			{
				var animateValue = ANIMATE_LIST.getValue();
				
				if( parseInt(animateValue).toString() == 'NaN' )
					slider.setAnimateListIndex(ANIMATE_LIST.getIndex());
				else
					slider.setAnimateListValue(animateValue);
			}
			break;
			case "setOrientation":
			{
				slider.setOrientationListIndex(ORIENTATION_LIST.getIndex());
			}
			break;
			
		}
	}
	
  slider.refresh();
  
	//Make sure the selection stays intact
  dom.setSelectedNode(selectedNode); 
  inspectSelection();
  
}
